% Clear workspace and close figures
clear Data
close all

% Prompt user to select one or multiple .txt files
[FILENAME, PATHNAME] = uigetfile('*.txt','MultiSelect', 'On');

% Ensure FILENAME is a cell array
if ~iscell(FILENAME)
    FILENAME = {FILENAME};
end

% Process each selected file
for NH = FILENAME
    clear Data
    close all
    filename = fullfile(PATHNAME, NH{1});
    delimiter = ',';
    
    % Initialize variables
    rawData = {};
    maxColumns = 0;
    
    % Open the file for reading
    fileID = fopen(filename, 'r');
    
    % Read the file line by line
    while ~feof(fileID)
        line = fgetl(fileID);
        if ischar(line)
            % Split the line by delimiter and remove whitespace
            values = strtrim(strsplit(line, ','));
            % Remove empty strings due to trailing commas or multiple commas
            values = values(~cellfun('isempty', values));
            % Update maxColumns if necessary
            maxColumns = max(maxColumns, length(values));
            % Append to rawData
            rawData{end+1, 1} = values;
        end
    end
    fclose(fileID);
    
    % Pad each line with 'NaN' to match maxColumns
    for i = 1:length(rawData)
        numValues = length(rawData{i});
        if numValues < maxColumns
            rawData{i}(end+1:maxColumns) = {'NaN'};
        end
    end
    
    % Convert rawData to a cell matrix
    raw = vertcat(rawData{:});
    
    % Initialize numericData with NaNs
    numericData = NaN(size(raw));
    
    % Define regex pattern for number extraction
    regexstr = '([-+]?\d*\.?\d+(?:[eE][-+]?\d+)?)';
    
    % Process each element in raw to convert to numeric data
    for col = 1:maxColumns
        for row = 1:size(raw, 1)
            item = raw{row, col};
            % Remove any whitespace
            item = strtrim(item);
            % Attempt to match the item to a number
            result = regexp(item, regexstr, 'match');
            if ~isempty(result)
                % Convert matched string to number
                num = str2double(result{1});
                numericData(row, col) = num;
                raw{row, col} = num;
            else
                % If no match, set as NaN
                numericData(row, col) = NaN;
                raw{row, col} = NaN;
            end
        end
    end
    
    % Remove rows and columns that are completely NaN
    % Remove rows where all elements are NaN
    validRows = ~all(isnan(numericData), 2);
    numericData = numericData(validRows, :);
    raw = raw(validRows, :);
    % Remove columns where all elements are NaN
    validCols = ~all(isnan(numericData), 1);
    numericData = numericData(:, validCols);
    raw = raw(:, validCols);
    
    % Convert raw cell array to matrix
    A = cell2mat(raw);
    
    % Display the number of columns and first few rows
    disp(['After processing, number of columns in A: ', num2str(size(A, 2))]);
    disp('First few rows of A:');
    disp(A(1:min(5, size(A,1)), :));  % Ensure we don't exceed the number of rows
    
    % Adjust requiredColumns based on actual data
    requiredColumns = size(A, 2);
    
    % Proceed with data processing
    % Adjust indices based on your data
    % For example:
    % A(:,2) - Data.Lat
    % A(:,3) - Data.Foreaft
    % A(:,4) - Data.Vert
    % A(:,5) - Data.Pitch
    % A(:,6) - Data.Roll
    % A(:,7) - Data.Yaw
    
    if requiredColumns >= 7
        Data.Lat = A(:, 1);
        Data.Foreaft = A(:, 2);
        Data.Vert = A(:, 3);
        Data.Pitch = A(:, 4);
        Data.Roll = A(:, 5);
        Data.Yaw = A(:, 6);
    else
        error('Not enough data columns to extract all required data channels.');
    end
    
    % Create a table from the Data structure
    DataTable = struct2table(Data);
    
    % Add a Time column if necessary
    % Assuming a simple time vector
    DataTable.Time = (1:size(DataTable, 1))';
    
    % Reorder columns to place Time as the first column
    DataTable = [DataTable(:, end), DataTable(:, 1:end-1)];
    
      chnl_lst=fieldnames(Data);
    Len=zeros(length(chnl_lst),1);
    for i=1:length(chnl_lst)
        Len(i)=length(Data.(chnl_lst{i}));
    end
    Data.N=mode(Len);
    I=find(Len==Data.N);
    Data.ChannelList=chnl_lst(I);
    Data.adfreq=1000*ones(1,length(I));
    Data.SampleCounts=Data.N*ones(1,length(I));
    Data.samples=Data.N*ones(1,length(I));

    char_tmp='                ';
    Data.ChannelNames=[];
    Data.ChannelNumbers=[];


    for i=1:length(I)
        tmp='                ';
        tmp2=chnl_lst{I(i)};
        tmp(1:min(length(tmp2),16))=tmp2(1:min(length(tmp2),16));
        Data.ChannelNames=[Data.ChannelNames;tmp];
        Data.Definitions{i}=['Data.' tmp2 '(1+lat:N)'];
        Data.ChannelNumbers(i)=0;
        Data.ChNumbers{i}={'0'};

    end
    if ~sum(strcmp('M',chnl_lst))
        Data.M=[1 Data.N];
    end
    Data.NumberOfChannels=length(Data.ChannelList);
    Data.latency=0;

    for i=1:length(Data.ChannelList)
        if size(Data.(Data.ChannelList{i}),1)==1

            Data.(Data.ChannelList{i})=Data.(Data.ChannelList{i}).';

        end
    end


    Data.NumberOfChannels=length(Data.ChannelList);
    Data.NumberOfSignals=length(Data.ChannelList);
    save([filename(1:end-4) '.mat'],'Data');
    
    % Save the DataTable to a CSV file
    [~, name, ~] = fileparts(filename);
    csvFilename = fullfile(PATHNAME, [name '.csv']);
    writetable(DataTable, csvFilename);
    
    % Optional: Display a message indicating successful save
    disp(['Data saved to CSV file: ', csvFilename]);
end
